<?php
/**
 * mngt functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package mngt
 */

if ( ! function_exists( 'mngt_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function mngt_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on mngt, use a find and replace
		 * to change 'mngt' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'mngt', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'mngt' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'mngt_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'mngt_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function mngt_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'mngt_content_width', 640 );
}
add_action( 'after_setup_theme', 'mngt_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function mngt_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'mngt' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'mngt' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'mngt_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function mngt_scripts() {
	wp_enqueue_style( 'mngt-style', get_stylesheet_uri() );

	wp_enqueue_script( 'mngt-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );

	wp_enqueue_script( 'mngt-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'mngt_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}



// custom post voiture
add_action('init', 'my_custom_init');
function my_custom_init()
{
/* notre code PHP pour rajouter les custom post type */
}

register_post_type(
  'voiture',
  array(
    'label' => 'Voitures',
    'labels' => array(
      'name' => 'Voitures',
      'singular_name' => 'voiture',
      'all_items' => 'Tous les voitures',
      'add_new_item' => 'Ajouter un voiture',
      'edit_item' => 'Éditer le voiture',
      'new_item' => 'Nouveau voiture',
      'view_item' => 'Voir le voiture',
      'search_items' => 'Rechercher parmi les voiture',
      'not_found' => 'Pas de voiture trouvé',
      'not_found_in_trash'=> 'Pas de voiture dans la corbeille'
      ),
    'public' => true,
    'capability_type' => 'post',
    'supports' => array(
      'title',
      'editor',
      'thumbnail',
      'excerpt',
      'trackbacks',
      'custom-fields',
      'revisions',
      'page-attributes'
    ),
    'has_archive' => true
  )
);
















// gtp_______________________________________________________________________



// gpt
function custom_theme_settings($wp_customize){
	$wp_customize->add_section("text_section", array(
	   "title" => "les textes du thème",
	   "priority" => 30,
	));
	$wp_customize->add_setting("nomsociete", array(
	   "default" => "Nom de la societe",
	));
	$wp_customize->add_control("nomsociete", array(
	   "label" => "Nom de la societe",
	   "section" => "text_section",
	   "type" => "text",
	));
	$wp_customize->add_setting("villenamelong", array(
	   "default" => "Valeur par défaut",
	));
	$wp_customize->add_control("villenamelong", array(
	   "label" => "Nom de la ville long(ex: à Nantes)",
	   "section" => "text_section",
	   "type" => "text",
	));
	$wp_customize->add_setting("villenamecourt", array(
		"default" => "Valeur par défaut",
	 ));
	 $wp_customize->add_control("villenamecourt", array(
		"label" => "Nom de la ville court(ex: Nantes)",
		"section" => "text_section",
		"type" => "text",
	 ));
	 $wp_customize->add_setting("numtela0e", array(
		"default" => "07 00 00 00 00",
	 ));
	 $wp_customize->add_control("numtela0e", array(
		"label" => "Numero de tel avec espace (ex: 07 66 34 65 54)",
		"section" => "text_section",
		"type" => "text",
	 ));
	 
	 $wp_customize->add_setting("numtels0", array(
		"default" => "700000000",
	 ));
	 $wp_customize->add_control("numtels0", array(
		"label" => "Numero de tel (sans le 0) (ex: 768348765)",
		"section" => "text_section",
		"type" => "text",
	 ));


	 $wp_customize->add_setting("mail", array(
		"default" => "700000000",
	 ));
	 $wp_customize->add_control("mail", array(
		"label" => "mail",
		"section" => "text_section",
		"type" => "text",
	 ));

	 $wp_customize->add_setting("snaplink", array(
		"default" => "#",
	 ));
	 $wp_customize->add_control("snaplink", array(
		"label" => "lien du snapchat",
		"section" => "text_section",
		"type" => "text",
	 ));		 
	 
	 $wp_customize->add_setting("snapname", array(
		"default" => "",
	 ));
	 $wp_customize->add_control("snapname", array(
		"label" => "nom du snap (laisser vide pour ne rien faire apparaitre)",
		"section" => "text_section",
		"type" => "text",
	 ));


	 $wp_customize->add_setting("snapmenu", array(
		"default" => "",
	 ));
	 $wp_customize->add_control("snapmenu", array(
		"label" => "snapchat dans le menu (laisser vide pour ne rien faire apparaitre)",
		"section" => "text_section",
		"type" => "text",
	 ));

	 $wp_customize->add_setting("instalink", array(
		"default" => "#",
	 ));
	 $wp_customize->add_control("instalink", array(
		"label" => "lien du insta",
		"section" => "text_section",
		"type" => "text",
	 ));		 
 }
 add_action("customize_register", "custom_theme_settings");
 
 
 
 function partie_legal($wp_customize){
	$wp_customize->add_section("legal_section", array(
	   "title" => "Parties legales",
	   "priority" => 30,
	));

	$wp_customize->add_setting("nom_director", array(
	   "default" => "",
	));
	$wp_customize->add_control("nom_director", array(
	   "label" => "Nom et prenom du directeur de la societe",
	   "section" => "legal_section",
	   "type" => "text",
	));


	$wp_customize->add_setting("formjuridique", array(
		"default" => "",
	 ));
	 $wp_customize->add_control("formjuridique", array(
		"label" => "Forme juridique",
		"section" => "legal_section",
		"type" => "text",
	 ));


	 $wp_customize->add_setting("adressesiegesocial", array(
		"default" => "",
	 ));
	 $wp_customize->add_control("adressesiegesocial", array(
		"label" => "Adresse du siege social",
		"section" => "legal_section",
		"type" => "text",
	 ));
	 
 }
 add_action("customize_register", "partie_legal");
 
 
 
 
 // Ajout de l'option de personnalisation pour une image
 function mon_theme_personnalisation( $wp_customize ) {
   // Ajouter une section pour les deux images
   $wp_customize->add_section( 'ma_section_images' , array(
	 'title'      => 'Images de fond',
	 'priority'   => 30,
   ) );
 
   // Ajouter un contrôle pour la premiere image
   $wp_customize->add_setting( 'ma_image_de_fond_1' );
 
   $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'ma_image_de_fond_1', array(
	 'label'      => 'Image de fond 1',
	 'section'    => 'ma_section_images',
	 'settings'   => 'ma_image_de_fond_1',
   ) ) );
 
   // Ajouter un contrôle pour la deuxieme image
   $wp_customize->add_setting( 'ma_image_de_fond_2' );
 
   $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'ma_image_de_fond_2', array(
	 'label'      => 'Image de fond 2',
	 'section'    => 'ma_section_images',
	 'settings'   => 'ma_image_de_fond_2',
   ) ) );
 }
 add_action( 'customize_register', 'mon_theme_personnalisation' );
 
 
 
 
 
 
 // texte predefini
 function mon_theme_personnalisation2( $wp_customize ) {
	$wp_customize->add_section( 'mon_html_section', array(
	   'title' => 'HTML Section',
	   'priority' => 30,
	) );
 
	$wp_customize->add_setting( 'mon_html_1', array(
	   'default' => '',
	) );
	$wp_customize->add_setting( 'mon_html_2', array(
	   'default' => '',
	) );
	$wp_customize->add_setting( 'mon_html_3', array(
	   'default' => '',
	) );
 
	$wp_customize->add_control( 'mon_html_1', array(
	   'label' => 'HTML 1',
	   'section' => 'mon_html_section',
	   'type' => 'textarea',
	) );
	$wp_customize->add_control( 'mon_html_2', array(
	   'label' => 'HTML 2',
	   'section' => 'mon_html_section',
	   'type' => 'textarea',
	) );
	$wp_customize->add_control( 'mon_html_3', array(
	   'label' => 'HTML 3',
	   'section' => 'mon_html_section',
	   'type' => 'textarea',
	) );
 }
 add_action( 'customize_register', 'mon_theme_personnalisation2' );
 
 
 
 
 
 // couleur
 function mon_theme_personnalisation3( $wp_customize ) {
	// Ajout d'une section pour les couleurs
	$wp_customize->add_section( 'mon_theme_couleurs', array(
	   'title'    => __( 'Couleurs', 'mon_theme' ),
	   'priority' => 30,
	) );
 
	// Ajout d'un champ pour la couleur principale
	$wp_customize->add_setting( 'mon_theme_couleur_principale', array(
	   'default'           => '#000000',
	   'sanitize_callback' => 'sanitize_hex_color',
	) );
 
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mon_theme_couleur_principale', array(
	   'label'    => __( 'Couleur principale', 'mon_theme' ),
	   'section'  => 'mon_theme_couleurs',
	   'settings' => 'mon_theme_couleur_principale',
	) ) );
 
	// Ajout d'un champ pour la couleur secondaire
	$wp_customize->add_setting( 'mon_theme_couleur_secondaire', array(
	   'default'           => '#000000',
	   'sanitize_callback' => 'sanitize_hex_color',
	) );
 
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mon_theme_couleur_secondaire', array(
	   'label'    => __( 'Couleur secondaire', 'mon_theme' ),
	   'section'  => 'mon_theme_couleurs',
	   'settings' => 'mon_theme_couleur_secondaire',
	) ) );
 
	// Ajout d'un champ pour la couleur tertiaire
	$wp_customize->add_setting( 'mon_theme_couleur_tertiaire', array(
	   'default'           => '#000000',
	   'sanitize_callback' => 'sanitize_hex_color',
	) );
 
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mon_theme_couleur_tertiaire', array(
	   'label'    => __( 'Couleur tertiaire', 'mon_theme' ),
	   'section'  => 'mon_theme_couleurs',
	   'settings' => 'mon_theme_couleur_tertiaire',
	) ) );
 }
 add_action( 'customize_register', 'mon_theme_personnalisation3' );
 
 
 
 
 
 
 // fonts
 function custom_theme_fonts() {
	 $fonts = array(
		 'Arial' => 'Arial, sans-serif',
		 'Courier New' => 'Courier New, Courier, monospace',
		 'Georgia' => 'Georgia, serif',
		 'Tahoma' => 'Tahoma, sans-serif',
		 'Times New Roman' => 'Times New Roman, serif',
		 'Verdana' => 'Verdana, sans-serif',
	 );
  
	 $selected_font = get_theme_mod('selected_font', 'Arial');
	 $font_family = $fonts[$selected_font];
  
	 ?>
	 <style>
		 body {
			 font-family: <?php echo $font_family; ?> !important;
		 }
	 </style>
	 <?php
 }
 add_action('wp_head', 'custom_theme_fonts');
  
 function custom_theme_customize_register($wp_customize) {
	 $wp_customize->add_section('custom_theme_fonts', array(
		 'title' => __('Fonts', 'custom_theme'),
		 'priority' => 30,
	 ));
  
	 $wp_customize->add_setting('selected_font', array(
		 'default' => 'Arial',
		 'type' => 'theme_mod',
		 'capability' => 'edit_theme_options',
		 'transport' => 'refresh',
	 ));
  
	 $wp_customize->add_control('selected_font', array(
		 'label' => __('Select Font', 'custom_theme'),
		 'section' => 'custom_theme_fonts',
		 'type' => 'select',
		 'choices' => array(
			 'Arial' => 'Arial',
			 'Courier New' => 'Courier New',
			 'Georgia' => 'Georgia',
			 'Tahoma' => 'Tahoma',
			 'Times New Roman' => 'Times New Roman',
			 'Verdana' => 'Verdana',
		 ),
	 ));
 }
 add_action('customize_register', 'custom_theme_customize_register');